
// analysis functions


function aeo(st,en)		//"st" and "en" must represent the first and last waves to be averaged; "aeo" = average every other
	variable st,en
	variable i=st
	wave w=$("w"+Num2Str(i))
	duplicate/o w avgwave
	i+=2
	do
		wave w=$("w"+Num2Str(i))
		avgwave+=w
		i+=2
	while (i<=en)
	avgwave/=(((en+2)-st)/2)
	blinesub("avgwave")
end

function blinesub(wname)
	string wname
	variable baseline
	wave w=$wname
	baseline=mean(w, pnt2x(w,2300), pnt2x(w,2499))
	w-=baseline
end

function avgwaves(st,en)
	variable st,en
	variable cnt=(en-st)+1
	wave w=$"w"+ Num2Str(st)
	duplicate/o w holdwave
	st+=1
	do
		wave w=$"w"+ Num2Str(st)
		holdwave+=w
		st+=1
	while(st<=en)
	holdwave/=cnt
end

function avgwaves2(st,en)
	variable st,en
	variable cnt=(en-st)+1
	wave c=$"c"+ Num2Str(st)
	duplicate/o c holdwave
	st+=1
	do
		wave c=$"c"+ Num2Str(st)
		holdwave+=c
		st+=1
	while(st<=en)
	holdwave/=cnt
end

Function ppr(cyclestart)
	variable cyclestart
	variable peak1,peak2,baseline1,baseline2
	variable st=1020,en=1080
	variable bst=950,bend=999
	variable i=cyclestart
	variable j=0
	variable wend=(cyclestart+5)
	variable epsc1amplitude,epsc2amplitude
	make/d/o/n=6 ppvalue
		ppvalue[0]=25
		ppvalue[1]=50
		ppvalue[2]=75
		ppvalue[3]=100
		ppvalue[4]=250
		ppvalue[5]=500
	make/d/o/n=6 ppcurve
	do
		wave w=$("w"+Num2Str(i))
		wavestats /q/r=[st,en] w
		peak1=(w[x2pnt(w,v_minloc)-2]+w[x2pnt(w,v_minloc)-1]+w[x2pnt(w,v_minloc)]+w[x2pnt(w,v_minloc)+1]+w[x2pnt(w,v_minloc)+2])/5
		baseline1=mean(w, pnt2x(w,bst), pnt2x(w,bend))
		baseline2=mean(w, pnt2x(w,bst+(ppvalue[j]*10)), pnt2x(w,bend+(ppvalue[j]*10)))
		epsc1amplitude=peak1-baseline1
		wavestats /q/r=[(st+(ppvalue[j]*10)),(en+(ppvalue[j]*10))] w
		peak2=(w[x2pnt(w,v_minloc)-2]+w[x2pnt(w,v_minloc)-1]+w[x2pnt(w,v_minloc)]+w[x2pnt(w,v_minloc)+1]+w[x2pnt(w,v_minloc)+2])/5
		epsc2amplitude=peak2-baseline2
		ppcurve[j]=epsc2amplitude/epsc1amplitude
		i+=1
		j+=1
	while(i<=wend)
	display ppcurve vs ppvalue
	ModifyGraph mode=4,marker=19
end

Function ak1(wst,wend)
	variable wst,wend
	variable peak,baseline,bline1,bline2
	variable i=wst
	wave epsc1amplitude,epsc2amplitude,onlineRs,epscholding,PPratio,ri
	do
		wave w=$("w"+Num2Str(i))
		wavestats /q/r=[2030,2130] w
		peak=(w[x2pnt(w,v_minloc)-2]+w[x2pnt(w,v_minloc)-1]+w[x2pnt(w,v_minloc)]+w[x2pnt(w,v_minloc)+1]+w[x2pnt(w,v_minloc)+2])/5
		baseline=mean(w, pnt2x(w,1000), pnt2x(w,1500))
		epsc1amplitude[i]=peak-baseline
		wavestats /q/r=[2530,2630] w
		peak=(w[x2pnt(w,v_minloc)-2]+w[x2pnt(w,v_minloc)-1]+w[x2pnt(w,v_minloc)]+w[x2pnt(w,v_minloc)+1]+w[x2pnt(w,v_minloc)+2])/5
		epsc2amplitude[i]=peak-baseline
		PPratio[i]=epsc2amplitude[i]/epsc1amplitude[i]
		bline1=mean(w, pnt2x(w,20), pnt2x(w,180))
		bline2=mean(w, pnt2x(w,350), pnt2x(w,390))
		ri[i]=10000/(-(bline2-bline1))
		i+=1
	while(i<=wend)
end

function normalize(base,st,en)
	variable st,en
	string base
	do
		wave w=$base+Num2Str(st)
		duplicate /o w $base+"n"+Num2Str(st)
		wave wx=$base+"n"+Num2Str(st)
		wavestats /q /r=[0,9] w
		wx/=(v_avg/100)
		st+=1
	while (st<=en)
end

function analysis(wbase,nump,a,b)
	variable a,b,nump
	string wbase
	string wname
	WAVE sum1,varsum
	Redimension /N=(nump) sum1, varsum
	sum1=0
	varsum=0
	variable c=0
	do
	variable i=a
	variable e=0
		do
			wave w=$wbase+Num2Str(i)
			variable d=numtype(w[c])
			if (d!=2)
				sum1[c]+=w[c]
				e+=1
			endif
			i+=1
		while(i<=b)
		sum1[c]/=e
		c+=1
	while(c<=(nump-1))
	c=0
	do
	i=a
	e=0
		do
			wave w=$wbase+Num2Str(i)
			d=numtype(w[c])
			if (d!=2)
				varsum[c]+=(w[c]-sum1[c])^2
				e+=1
			endif
			i+=1
		while(i<=b)
		varsum[c]/=e
		varsum[c]=sqrt(varsum[c])
		varsum[c]/=sqrt(e)
		c+=1
	while(c<=(nump-1))
end

macro load(base,a,b)
	variable a,b
	string base
	string whatever="C:\Documents and Settings\Anatol Kreitzer\Desktop\Mini Experiments\miniwaves"
	string wname	
	do
		wname=(base+Num2Str(a)+".ibw")
		NewPath/O crap whatever 
		LoadWave /H /P=crap wname
		a+=1
	while(a<=b)
endmacro

Function ButtonProc_11(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	variable st,en
	switch( ba.eventCode )
		case 2: // mouse up
			avgwaves(st,en)
			break
	endswitch

	return 0
End

Function IVaverageCh0(st)
	variable st
	variable bl
	variable k=0
	wave w=$("w"+Num2str(st))
	duplicate/o w avgwave
	make/O/N=8 IVepsc
	do
		wave a1=$("w"+Num2str(st))
		wave a2=$("w"+Num2str(st+8))
		wave a3=$("w"+Num2str(st+16))
		avgwave=(a1+a2+a3)/3
		//get EPSC1 amp
		wavestats/q/r=(0.30,0.34) avgwave
		bl=v_avg
		wavestats/q/r=(0.3525,0.40) avgwave
		if (v_min+v_max<0)
			IVepsc[k]=v_min-bl
		else 
			IVepsc[k]=v_max-bl
		endif
		st+=1
		k+=1
	while(k<8)
	edit IVepsc
End

Function IVaverageCh1(st)
	variable st
	variable bl
	variable k=0
	wave c=$("c"+Num2str(st))
	duplicate/o c avgwave
	make/O/N=8 IVepsc
	do
		wave a1=$("c"+Num2str(st))
		wave a2=$("c"+Num2str(st+8))
		wave a3=$("c"+Num2str(st+16))
		avgwave=(a1+a2+a3)/3
		//get EPSC1 amp
		wavestats/q/r=(0.30,0.34) avgwave
		bl=v_avg
		wavestats/q/r=(0.35,0.40) avgwave
		if (v_min+v_max<0)
			IVepsc[k]=v_min-bl
		else 
			IVepsc[k]=v_max-bl
		endif
		st+=1
		k+=1
	while(k<8)
	edit IVepsc
End		


Function IVvaluesCh0(st)
	variable st
	variable bl
	variable k=0
	wave w=$("w"+Num2str(st))
	make/O/N=8 IVepsc
	do
		wave w=$("w"+Num2str(st))
		//get EPSC1 amp
		wavestats/q/r=(0.30,0.34) w
		bl=v_avg
		wavestats/q/r=(0.3525,0.40) w
		if (v_min+v_max<0)
			IVepsc[k]=v_min-bl
		else 
			IVepsc[k]=v_max-bl
		endif
		st+=1
		k+=1
	while(k<8)
	edit IVepsc
End


Function IVvaluesCh1(st)
	variable st
	variable bl
	variable k=0
	wave c=$("c"+Num2str(st))
	make/O/N=8 IVepsc
	do
		wave c=$("c"+Num2str(st))
		//get EPSC1 amp
		wavestats/q/r=(0.30,0.34) c
		bl=v_avg
		wavestats/q/r=(0.35,0.40) c
		if (v_min+v_max<0)
			IVepsc[k]=v_min-bl
		else 
			IVepsc[k]=v_max-bl
		endif
		st+=1
		k+=1
	while(k<8)
	edit IVepsc
End


function InputResistanceCh0(st,en)
	variable st,en
	variable bl
	variable deltai
	variable resist
	avgwaves(st,en)
	wavestats/q/r=(0,0.005) holdwave
	bl=v_avg
	wavestats/q/r=(0.02,0.025) holdwave
	deltai=bl-v_avg
	resist=(5/deltai)*1000
	print resist
End	

function InputResistanceCh1(st,en)
	variable st,en
	variable bl
	variable deltai
	variable resist
	avgwaves2(st,en)
	wavestats/q/r=(0,0.005) holdwave
	bl=v_avg
	wavestats/q/r=(0.02,0.025) holdwave
	deltai=bl-v_avg
	resist=(5/deltai)*1000
	print resist
End	


Function ButtonProc_12(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	variable st,en
	switch( ba.eventCode )
		case 2: // mouse up
			avgwaves(st,en)
			break
	endswitch

	return 0
End

Function ButtonProc_13(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	variable st,en
	switch( ba.eventCode )
		case 2: // mouse up
			avgwaves2(st,en)
			break
	endswitch

	return 0
End

Function ButtonProc_14(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	variable st,en
	switch( ba.eventCode )
		case 2: // mouse up
			InputResistanceCh0(st,en)
			break
	endswitch

	return 0
End

Function ButtonProc_15(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	variable st,en
	switch( ba.eventCode )
		case 2: // mouse up
			InputResistanceCh1(st,en)
			break
	endswitch

	return 0
End

Function ButtonProc_16(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	variable st
	switch( ba.eventCode )
		case 2: // mouse up
		IVaverageCh0(st)
			break
	endswitch

	return 0
End

Function ButtonProc_17(ba) : ButtonControl
	STRUCT WMButtonAction &ba
	variable st
	switch( ba.eventCode )
		case 2: // mouse up
		IVaverageCh1(st)
			break
	endswitch

	return 0
End

Function ButtonProc_18(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			// IVvaluesCh0(st)
			break
	endswitch

	return 0
End

Function ButtonProc_19(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			// IVvaluesCh1(st)
			break
	endswitch

	return 0
End

Window PhilAnalysis() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(811,56,1008,219)
	TitleBox title0,pos={5,5},size={27,21},title="Ch0"
	TitleBox title1,pos={105,5},size={27,21},title="Ch1"
	SetVariable setvar0,pos={5,25},size={70,16},title="Start",value= st
	SetVariable setvar1,pos={105,25},size={70,16},title="End",value= en
	Button button0,pos={5,50},size={50,20},proc=ButtonProc_12,title="Average"
	Button button1,pos={105,50},size={50,20},proc=ButtonProc_13,title="Average"
	Button button2,pos={5,75},size={50,20},proc=ButtonProc_14,title="Rin"
	Button button3,pos={105,75},size={50,20},proc=ButtonProc_15,title="Rin"
	Button button4,pos={5,100},size={80,20},proc=ButtonProc_16,title="IV 3X average"
	Button button5,pos={105,100},size={80,20},proc=ButtonProc_17,title="IV 3X average"
	Button button6,pos={5,125},size={80,20},proc=ButtonProc_18,title="IV 1X Average"
	Button button7,pos={105,125},size={80,20},proc=ButtonProc_19,title="IV 1X Average"
EndMacro